/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queryparser.flexible.standard.builders;

import java.util.List;
import org.apache.lucene.ars_nouveau.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.ars_nouveau.queryparser.flexible.core.builders.QueryTreeBuilder;
import org.apache.lucene.ars_nouveau.queryparser.flexible.core.messages.QueryParserMessages;
import org.apache.lucene.ars_nouveau.queryparser.flexible.core.nodes.BooleanQueryNode;
import org.apache.lucene.ars_nouveau.queryparser.flexible.core.nodes.ModifierQueryNode;
import org.apache.lucene.ars_nouveau.queryparser.flexible.core.nodes.QueryNode;
import org.apache.lucene.ars_nouveau.queryparser.flexible.messages.MessageImpl;
import org.apache.lucene.ars_nouveau.queryparser.flexible.standard.builders.StandardQueryBuilder;
import org.apache.lucene.ars_nouveau.queryparser.flexible.standard.parser.EscapeQuerySyntaxImpl;
import org.apache.lucene.ars_nouveau.search.BooleanClause;
import org.apache.lucene.ars_nouveau.search.BooleanQuery;
import org.apache.lucene.ars_nouveau.search.IndexSearcher;
import org.apache.lucene.ars_nouveau.search.Query;

public class BooleanQueryNodeBuilder
implements StandardQueryBuilder {
    @Override
    public BooleanQuery build(QueryNode queryNode) throws QueryNodeException {
        BooleanQueryNode booleanNode = (BooleanQueryNode)queryNode;
        BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
        List<QueryNode> children = booleanNode.getChildren();
        if (children != null) {
            for (QueryNode child : children) {
                Object obj = child.getTag(QueryTreeBuilder.QUERY_TREE_BUILDER_TAGID);
                if (obj == null) continue;
                Query query = (Query)obj;
                try {
                    bQuery.add(query, BooleanQueryNodeBuilder.getModifierValue(child));
                }
                catch (IndexSearcher.TooManyClauses ex) {
                    throw new QueryNodeException(new MessageImpl(QueryParserMessages.TOO_MANY_BOOLEAN_CLAUSES, IndexSearcher.getMaxClauseCount(), queryNode.toQueryString(new EscapeQuerySyntaxImpl())), (Throwable)ex);
                }
            }
        }
        return bQuery.build();
    }

    private static BooleanClause.Occur getModifierValue(QueryNode node) {
        if (node instanceof ModifierQueryNode) {
            ModifierQueryNode mNode = (ModifierQueryNode)node;
            switch (mNode.getModifier()) {
                case MOD_REQ: {
                    return BooleanClause.Occur.MUST;
                }
                case MOD_NOT: {
                    return BooleanClause.Occur.MUST_NOT;
                }
                case MOD_NONE: {
                    return BooleanClause.Occur.SHOULD;
                }
            }
        }
        return BooleanClause.Occur.SHOULD;
    }
}

